<?php
/**
 * Autoloader für JenvaBackupMigration 2.0
 * 
 * @package JenvaBackupMigration
 * @since 2.0.0
 */

namespace JenvaBackupMigration;

if (!defined('ABSPATH')) {
    exit;
}

class Autoloader {
    
    private static $namespace = 'JenvaBackupMigration\\';
    private static $base_dir;
    private static $registered = false;
    
    public static function register(): void {
        if (self::$registered) {
            return;
        }
        
        self::$base_dir = plugin_dir_path(__FILE__);
        spl_autoload_register([self::class, 'load']);
        self::$registered = true;
    }
    
    public static function load(string $class): void {
        if (strpos($class, self::$namespace) !== 0) {
            return;
        }
        
        $relative_class = substr($class, strlen(self::$namespace));
        $file = self::$base_dir . str_replace('\\', '/', $relative_class) . '.php';
        
        if (file_exists($file)) {
            require_once $file;
        }
    }
}

Autoloader::register();

